package com.agilex.healthcare.veteranappointment.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.mobilehealthplatform.domain.ObjectTypeable;
import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;
import com.fasterxml.jackson.annotation.*;
import org.apache.commons.beanutils.BeanComparator;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;


@JsonIgnoreProperties(ignoreUnknown = true, value = { "size" })
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public class VARDomainTransferObjectCollection<T> extends ArrayList<T> implements ObjectTypeable  {
	@JsonCreator
	public VARDomainTransferObjectCollection(){
		super();
	}

	private static final long serialVersionUID = -8317600205607469695L;
	private AtomLinks links = null;

	@JsonProperty("link")
	public AtomLinks getLink() {
		if (this.links == null) {
			this.links = new AtomLinks();
		}

		return this.links;
	}

	public AtomLink getSelfLink() {
		return getLink().getSelfLink();
	}

	public URI getSelfUri() {
		AtomLink link = getSelfLink();
		return AtomLink.extractUri(link);
	}

	public void setSelfUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.self);
		getLink().setSelfLink(link);
	}

	@JsonProperty("size")
	public int getListSize() {
		return super.size();
	}
	
	@SuppressWarnings("unchecked")
	private void sort(String property, boolean isDescending){
		
		BeanComparator comparator = new BeanComparator(property);
		Collections.sort(this, comparator);
		if(isDescending){
			Collections.reverse(this);
		}
	}

	public void sortAscending(String property){
		this.sort(property, false);
	}
	
	public void sortDescending(String property){
		this.sort(property, true);
	}

	@JsonProperty("objectType")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}
}
